type Palabra      = String
type SopaDeLetras = [Palabra]
type Diccionario  = [Palabra]

type Lectora = [Palabra] -> [Palabra]

extraePalabras :: SopaDeLetras -> Diccionario -> [Palabra]
extraePalabrasContando :: SopaDeLetras -> Diccionario -> [(Palabra,Int)]


--------------------------------------------
type Posicin = Int
busca :: String -> String -> [Posicin]


busca [] bs = []
busca ps bs = buscaPrefijosDesde 1 ps bs


buscaPrefijosDesde :: Posicin -> String -> String -> [Posicin]

buscaPrefijosDesde _   _  []         = []
buscaPrefijosDesde pos as bs@(b:bs') =
                [ pos | prefijo as bs ] ++
                buscaPrefijosDesde (pos+1) as bs'

busca' as bs = [p | 
   p <- [1..length bs - length as+1], prefijo as (drop (p-1) bs) ]


prefijo :: String -> String -> Bool
prefijo []     _      = True
prefijo _      []     = False
prefijo (a:as) (b:bs) = a==b && prefijo as bs


--------------------------------------------
-- calculando las diagonales
--------------------------------------------

dia,tra,esp :: Lectora

dia [f] = map (\x -> [x]) f
--dia [f] = map (:[]) f
dia (f:fs) = pegar f ([]:dia fs)

pegar []     ds      = ds
pegar (a:as) (d:ds)  = (d++[a]) : pegar as ds


foldr1e           :: (a -> b -> b) -> (a -> b) -> [a] -> b
foldr1e u v [x]      = v x
foldr1e u v (x:xs)   = u x (foldr1e u v xs)

dia' = foldr1e u (map (:[]))
 where u x = pegar x . ([]:)


tra ([]:_) = []
tra fs = [ x |x:xs <-fs] : tra [ xs | x:xs<-fs]

--esp :: SopaDeLetras -> SopaDeLetras
esp = map reverse
	

lecturas :: Lectora
lecturas sopa = concat [ f sopa | f<- movimientos ]
  where movimientos = [ id, tra, esp, esp.tra, dia, dia.tra, dia. esp, dia. tra. esp ]

-- observe los movimientos no son 
--	[ id, tra, esp, esp.tra ] 
--	map (dia .) [ id, tra, esp, esp.tra ] 
-- ya que las funciones "dia . esp . tra" y "dia . tra. esp" son distintas,
-- auque las lecturas dada con "esp. tra" y con "tra.esp" son las mismas,
-- pero sus diagonales no lo son
-- "tra.esp" devuelve


{-
concat [ (f3 . f2 . f1 ) sopa | 
		f3<-[id,dia],
		f2<-[id,esp], 
		f1<-[id,tra] ]
-}

extraePalabras sopa = 
       filter (\p -> [] /= concat [ busca p l | l<- lecturas sopa])

extraePalabras' sopa dic  = 
       [ p | l<- lecturas sopa, p <- dic, busca p l /=[]]


extraePalabrasContando  sopa =  map (\p ->  (p, (length . concat) [ busca p l | l<- lecturas sopa]) )


miSopa,miSopa2,miSopa3 ::  SopaDeLetras
miSopa = [ "casacasa", "aapesaxx", "mxxaxxxx"]

miSopa2 = [ ['b'..'g'], ['c'..'h'] ]
miSopa3 = [ ['b'..'i'], ['c'..'j'], ['d'..'k'],['e'..'l'],['f'..'m'] ]

miSopa4 = [ ['1'..'3'],['4'..'6']]

mp2 = [ "dfh","ff"]

p2 = extraePalabras miSopa2 mp2
pV2 = extraePalabrasContando miSopa2 mp2

--pV3' = extraePalabrasVeces' ms3 mp3

misPalabras :: Diccionario
misPalabras = [ "casa","saco","mas","pesa", "asa" ]

p1 = extraePalabras miSopa misPalabras


{-
"casacasa","aapesasx","mxxaxaxx",
"cam","aax","spx","aea","csx","aaa","ssx","axx",
"asacasac","xsasepaa","xxaxaxxm",
"mac","xaa","xps","aea","xsc","aaa","xss","xxa",
"c","aa","mas","xpa","xec","asa","xas","asa","xx","x",
"c","aa","sam","apx","cex","asa","sax","asa","xx","x",
"a","xs","xsa","xac","asa","xes","apa","xac","xa","m",
"m","xa","xac","apa","xes","asa","xac","xsa","xs","a"



"abcdef","bcdefg","cdefgh",
"abc","bcd","cde","def","efg","fgh",
"fedcba","gfedcb","hgfedc",
"cba","dcb","edc","fed","gfe","hgf",

"a","bb","ccc","ddd","eee","fff","gg","h",
"a","bb","ccc","ddd","eee","fff","gg","h",
"f","ge","hfd","gec","fdb","eca","db","c",
,"a","sx","asx","cax","asa","sex","apa","cax","ax","m"]
"c","db","eca","fdb","gec","hfd","ge","f"   mal


-}